/*******************************************************************************
	[MainBoard.h]

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
*******************************************************************************/
#ifndef MAIN_BOARD_H
#define MAIN_BOARD_H


#include <stdio.h>

#include "TypeDefs.h"
#include "CPU.h"
#include "VDC.h"
#include "VCE.h"
#include "APU.h"
#include "PSG.h"
#include "IntCtrl.h"
#include "Timer.h"
#include "Cartridge.h"
#include "JoyPad.h"
#include "CDROM.h"


enum RamType
{
	MAINBOARD_MAINRAM = 0,
	MAINBOARD_BUFFERRAM,
	MAINBOARD_ARCADERAM
};


#define MAINBOARD_WATCHPOINT		1
#define MAINBOARD_BREAKPOINT		2


BOOL
MAINBOARD_Init(
	const char*		pGameName);

void
MAINBOARD_Deinit();

void
MAINBOARD_Pause(
	BOOL		bPause);

BOOL
MAINBOARD_SaveBRAM(
	const char*		pathName);

BOOL
MAINBOARD_LoadBRAM(
	const char*		pathName);


void
MAINBOARD_Reset();


Sint32
MAINBOARD_AdvanceFrame();

Sint32
MAINBOARD_AdvanceInstruction();

void
MAINBOARD_Update();

void
MAINBOARD_SwitchMemoryEditor();

Uint8
MAINBOARD_ReadByte(
	Uint32		physAddr);

void
MAINBOARD_WriteByte(
	Uint32		physAddr,
	Uint8		data);

void
MAINBOARD_ActivateIRQ1();

void
MAINBOARD_ActivateIRQ2();

void
MAINBOARD_ActivateTIRQ();


BOOL
MAINBOARD_ChangeScreenMode(
	Sint32		screenWidth,
	Sint32		screenHeight,
	Sint32		magnification,
	Sint32		bitsPerPixel,
	BOOL		bFullScreen,
	BOOL		bScanLine,
	BOOL		bStretched,
	BOOL		bSync60HzScreen,
	BOOL		bHardwareAcceleration);


BOOL
MAINBOARD_ChangeSoundMode(
	Uint32		bufferSize,
	Uint32		sampleRate,
	Uint32		overSampleRate,
	Uint32		masterVolume,
	BOOL		bReverb);

BOOL
MAINBOARD_ChangeButtonConnection(
	Sint32		joyID,
	Sint32		pceButton,
	Sint32		appButton);

void
MAINBOARD_ChangeFPS(
	float		fps);

BOOL
MAINBOARD_SaveState(
	FILE*		p);

BOOL
MAINBOARD_LoadState(
	FILE*		p);

void
MAINBOARD_ChangeMemoryValue(
	Sint32		ramType,
	Uint32		addr,
	Uint8		data);


#endif /* MAIN_BOARD_H */
